import React from 'react';
import ModalActions from 'actions/Modal';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import AddForm from '../Forms/Add';

const Add = React.createClass({

    _handleAddClick() {
        Metrika.send(
            'Настройки организации', 'Администраторы',
            'Клик по плюсу'
        );

        ModalActions.open({
            title: i18n('organization_admins.new_admins'),
            component: AddForm,
            props: {
                onSubmit: this._handleFormDone,
                onCancel: this._handleFormDone,
            },
        });
    },

    _handleFormDone() {
        ModalActions.close();
    },

    render() {
        return (
            <div
                className="add-section-item-control"
                ref="addControl"
            >
                <FlatButton
                    className="plus-button"
                    onClick={this._handleAddClick}
                    width="available"
                    ariaLabel={i18n('organization_admins.action_description.add_admins')}
                >

                    <Icon type="plus-solid-circle" />
                    <FlatButton.Label>{i18n('common.action.add')}</FlatButton.Label>
                </FlatButton>
            </div>
        );
    },

});

export default Add;
