import React from 'react';
import UIActions from 'actions/UI';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import Metrika from 'lib/metrika';

import { i18n } from 'lib/i18n';

const EditAdmins = React.createClass({

    _handleEditClick() {
        Metrika.send(
            'Настройки организации', 'Администраторы',
            'Клик на карандаш'
        );

        UIActions.editOrganizationAdmins(this.props);
    },

    _handleDoneClick() {
        Metrika.send(
            'Настройки организации', 'Администраторы',
            'Закрытие редактирования'
        );

        UIActions.organizationAdminsEdited(this.props);
    },

    render() {
        return (
            <div className="edit-org-admin-list-controls edit-section-controls">
                <FlatButton className="edit" onClick={this._handleEditClick}>
                    <Icon type="pen" />
                </FlatButton>
                <FlatButton
                    className="done"
                    onClick={this._handleDoneClick}
                    ariaLabel={i18n('organization_admins.action_description.edit_admins')}
                >

                    <Icon type="cross" />
                </FlatButton>
            </div>
        );
    },

});

export default EditAdmins;
