import React from 'react';
import ModalActions from 'actions/Modal';
import UIActions from 'actions/UI';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import RemoveForm from '../Forms/Remove';

const Remove = React.createClass({

    _handleClick() {
        Metrika.send(
            'Настройки организации', 'Администраторы',
            'Клик по корзине'
        );

        ModalActions.open({
            title: i18n('organization_admins.message.confirm_removal'),
            component: RemoveForm,
            props: {
                onSubmit: this._handleFormDone,
                onCancel: this._handleFormCancel,
            },
        });
    },

    _handleFormDone() {
        UIActions.organizationAdminsEdited();
        ModalActions.close();
    },

    _handleFormCancel() {
        ModalActions.close();
    },

    render() {
        return (
            <div
                className="add-section-item-control"
                ref="addControl"
            >
                <FlatButton
                    onClick={this._handleClick}
                    width="available"
                    ariaLabel={i18n('organization_admins.action_description.remove_admins')}
                >

                    <Icon type="trash" />
                </FlatButton>
            </div>
        );
    },

});

export default Remove;
