import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import UIStore from 'stores/UI';

import Add from './Controls/Add';
import Remove from './Controls/Remove';

const Footer = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        return { editable: UIStore.isOrganizationAdminListEditable(this.props) };
    },

    componentDidMount() {
        this.subscribe(UIStore);
    },

    render() {
        const Edit = this.state.editable ? Remove : Add;

        return (
            <div className="org-admins-footer section-footer">
                <Edit />
            </div>
        );
    },

});

export default Footer;
