import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';

import UserStore from 'stores/Users';
import GroupStore from 'stores/Groups';
import { i18n } from 'lib/i18n';
import Edit from './Controls/Edit';

const Header = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        return { key: this.hashCode() };
    },

    componentDidMount() {
        this.subscribe([GroupStore, UserStore]);
    },

    render() {
        const group = GroupStore.getAdminGroup();

        if (!group || !group.getMembers().length) {
            return null;
        }

        return (
            <div className="org-admin-list-subheader section-subheader">
                <h2 className="section-subheader__title">
                    {i18n('organization_admins.title')}
                </h2>
                <Edit />
            </div>
        );
    },

});

export default Header;
