import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import classSet from 'classnames';
import StoreMixin from 'lib/StoreMixin';
import UIStore from 'stores/UI';

import SettingsLoader from 'components/SettingsLoader';
import Header from './Header';
import Footer from './Footer';
import List from './List';

import './index.css';

const OrgAdmins = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        return { editable: UIStore.isOrganizationAdminListEditable() };
    },

    componentDidMount() {
        this.subscribe(UIStore);
    },

    render() {
        const className = classSet({
            'org-admin-section': true,
            'column-section': true,
            'column-section_editable': this.state.editable,
            section: true,
        });

        return (
            <div className={className}>
                <Header />
                <div className="section-body">
                    <List />
                </div>
                <Footer />
                <SettingsLoader />
            </div>
        );
    },

});

export default OrgAdmins;
