import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import Link from 'ui/Link';
import Url from 'lib/Url';
import { i18n } from 'lib/i18n';

const Contacts = React.createClass({

    render() {
        const { organization } = this.props;
        const contacts = organization.getContacts().filter(item => Boolean(item.value));

        const items = contacts.map((item, index) => {
            const label = i18n(`organization_profile.contacts.${item.type}`) || _.capitalize(item.type);
            let link;

            if (item.type === 'email') {
                link = (
                    <Link className="link" to={Url.getEmail(item.value)} target="_blank">
                        {item.value}
                    </Link>
                );
            }

            return (
                <div className="list-item" key={index}>
                    <div className="list-item__key" title={label}>
                        {label}:
                    </div>
                    <div className="list-item__value">
                        {link || item.value}
                    </div>
                </div>
            );
        });

        if (!items.length) {
            items.push(
                <div className="warning" key="warning">
                    {i18n('organization_profile.contacts.data_unavailable')}
                </div>
            );
        }

        return (
            <div className="org-contacts list separated-subsection">
                <h2 className="subsection-title">
                    {i18n('organization_profile.contacts._title')}
                </h2>
                {items}
            </div>
        );
    },

});

Contacts.propTypes = {
    organization: PropTypes.object,
};

export default Contacts;
