import PropTypes from 'prop-types';
import React from 'react';
import { Permissions } from 'constants/Common';
import PermissionStore from 'stores/Permissions';
import Logo from './Logo';

const Identity = React.createClass({

    render() {
        const { organization } = this.props;

        return (
            <div className="org-identity subsection">
                <Logo
                    organization={organization}
                    editable={PermissionStore.contains(Permissions.CHANGE_LOGO)}
                />
                <div className="org-profile-name">
                    {organization.getName()}
                </div>
            </div>
        );
    },

});

Identity.propTypes = {
    organization: PropTypes.object,
};

export default Identity;
