import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';

const FIELD_MAP = {
    law_address: 'legal_address',
    real_address: 'actual_address',
    trc: 'kpp',
    corr_acc: 'correspondent_account',
};

const LegalInfo = React.createClass({

    render() {
        const { organization, locale } = this.props;
        const legalInfo = organization.getLegalInfo().filter(item => Boolean(item.value));

        const items = legalInfo.map((item, index) => {
            const key = i18n(`organization_profile.legal_info.${FIELD_MAP[item.type] || item.type}`);

            return (
                <div className="list-item" key={index}>
                    <div className="list-item__key" title={key}>
                        {key}:
                    </div>
                    <div className="list-item__value">
                        {item.value}
                    </div>
                </div>
            );
        });

        const head = { user: organization.getHead() };

        if (head.user) {
            head.position = head.user.getPosition(locale) ||
                i18n('organization_profile.legal_info.head');
            head.name = head.user.getAlphabeticalName(locale);

            items.push(
                <div className="list-item" key="head">
                    <div className="list-item__key" title={head.position}>
                        {head.position}:
                    </div>
                    <div className="list-item__value">
                        {head.name}
                    </div>
                </div>
            );
        }

        if (!items.length) {
            items.push(
                <div className="warning" key="warning">
                    {i18n('organization_profile.legal_info.data_unavailable')}
                </div>
            );
        }

        return (
            <div className="org-legal-info list separated-subsection">
                <h2 className="subsection-title">
                    {i18n('organization_profile.legal_info._title')}
                </h2>
                {items}
            </div>
        );
    },

});

LegalInfo.propTypes = {
    organization: PropTypes.object,
    locale: PropTypes.string,
};

LegalInfo.defaultProps = {
    locale: 'ru',
};

export default LegalInfo;
