import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Url from 'lib/Url';
import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import AuthStore from 'stores/Auth';

const TechnicalDetails = React.createClass({

    _renderItem(key, value, details) {
        return (
            <div className="list-item" key={Math.random()}>
                <div className="list-item__key" title={key}>
                    {key}:
                </div>
                <div className="list-item__value">
                    {value}
                    {details}
                </div>
            </div>
        );
    },

    _renderDomainDetails() {
        if (this.props.organization.get('has_natural_domains')) {
            return null;
        }

        return (
            <FlatButton
                className="plus-button"
                onClick={() => Url.open(Url.getLocation(Url.getPath('services/webmaster#add-domain')))}
                ariaLabel={i18n('domain.action_description.add')}
            >
                <Icon type="plus-solid-circle" />
            </FlatButton>
        );
    },

    render() {
        const { organization } = this.props;
        const component = {};
        const warnings = [];

        component.items = [
            this._renderItem(
                i18n('organization_profile.technical_details.natural_domains.title'),
                organization.get('has_natural_domains') ?
                    i18n('organization_profile.technical_details.natural_domains.present') :
                    i18n('organization_profile.technical_details.natural_domains.absent'),
                this._renderDomainDetails()
            ),
            this._renderItem(
                i18n('organization_profile.technical_details.users'),
                organization.get('user_count')
            ),
            this._renderItem(
                i18n('organization_profile.technical_details.departments'),
                organization.get('department_count')
            ),
            this._renderItem(
                i18n('organization_profile.technical_details.groups'),
                organization.get('group_count')
            ),
            this._renderItem(
                i18n('organization_profile.technical_details.admins'),
                organization.get('admin_count')
            ),
        ];

        if (AuthStore.isPartnerOrganization()) {
            component.items.push(
                this._renderItem(
                    i18n('organization_profile.technical_details.partner_id'),
                    organization.get('partner_id') || '—'
                )
            );
        }

        if (organization.get('admin_count') < 2) {
            warnings.push(i18n('organization_profile.technical_details.warning.too_few_admins'));
        }

        if (warnings.length) {
            component.warnings = (
                <div className="info-warning">
                    {warnings.map((item, index) => <p key={index}>{item}</p>)}
                </div>
            );
        }

        return (
            <div className="org-technical-details list separated-subsection">
                <h2 className="subsection-title">
                    {i18n('organization_profile.technical_details._title')}
                </h2>
                {component.items}
                {component.warnings}
            </div>
        );
    },

});

TechnicalDetails.propTypes = {
    organization: PropTypes.object,
    locale: PropTypes.string,
};

TechnicalDetails.defaultProps = {
    locale: 'ru',
};

export default TechnicalDetails;
