import React from 'react';
import Popup from 'react-bem-components/lib/Popup';
import Metrika from 'lib/metrika';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import { i18n } from 'lib/i18n';
import EditMenu from './EditMenu';

const Edit = React.createClass({

    componentDidMount() {
        this._anchorPopup();
    },

    componentDidUpdate() {
        this._anchorPopup();
    },

    _anchorPopup() {
        if (this.refs.editPopup && this.refs.editControl) {
            this.refs.editPopup.setAnchor(this.refs.editControl);
        }
    },

    _handleEditClick() {
        if (this.refs.editPopup) {
            Metrika.send('Профиль организации', 'Клик в троеточие');
            this.refs.editPopup.block.toggleMod('visible');
        }
    },

    _handleMenuSelect() {
        if (this.refs.editPopup) {
            Metrika.send('Профиль организации', 'КМ', 'Редактировать');
            this.refs.editPopup.close();
        }
    },

    render() {
        return (
            <div
                className="edit-org-profile-controls edit-section-controls"
                ref="editControl"
            >
                <FlatButton
                    onClick={this._handleEditClick}
                    ariaLabel={i18n('common.action.edit')}
                >

                    <Icon type="dots" />
                </FlatButton>
                <Popup
                    ref="editPopup"
                    closable
                    directions={['bottom-right']}
                    target="anchor"
                >
                    <EditMenu
                        organization={this.props.organization}
                        onSelect={this._handleMenuSelect}
                    />
                </Popup>
            </div>
        );
    },
});

Edit.propTypes = {

};

export default Edit;
