import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Input from 'ui/Input';

const Contacts = React.createClass({

    render() {
        const { organization, errors } = this.props;
        const contacts = organization.getContacts();

        const items = contacts.map((item, index) => {
            const label = i18n(`organization_profile.contacts.${item.type}`) || _.capitalize(item.type);

            return (
                <Form.Item
                    key={index}
                    label={label}
                    errors={errors[_.camelCase(item.type)]}
                >
                    <Input
                        name={item.type}
                        hasClear
                        size="m"
                        autoComplete={false}
                        width="available"
                        val={item.value}
                    />
                </Form.Item>
            );
        });

        return (
            <div className="form__subsection">
                {items}
            </div>
        );
    },

});

Contacts.propTypes = {
    organization: PropTypes.object,
    errors: PropTypes.object,
};

export default Contacts;
