import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Input from 'ui/Input';

const Identity = React.createClass({

    render() {
        const { organization, errors } = this.props;

        return (
            <div className="form__subsection">
                <div className="org-profile-logo" />
                <Form.Item
                    key="name"
                    label={i18n('organization_profile.identity.name')}
                    required
                    errors={errors.name}
                >
                    <Input
                        name="name"
                        hasClear
                        size="m"
                        autoComplete={false}
                        width="available"
                        val={organization.getName()}
                    />
                </Form.Item>
            </div>
        );
    },

});

Identity.propTypes = {
    organization: PropTypes.object,
    errors: PropTypes.object,
};

export default Identity;
