import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Input from 'ui/Input';
import SuggestPicker from 'components/SuggestPicker';

const FIELD_MAP = {
    law_address: 'legal_address',
    real_address: 'actual_address',
    trc: 'kpp',
    corr_acc: 'correspondent_account',
};

const LegalInfo = React.createClass({

    getInitialState() {
        return { head: this.props.organization.getHead() };
    },

    _handlePickerChange(items) {
        // только один руководитель
        this.setState({ head: items[0] || null });
    },

    render() {
        const { head } = this.state;
        const { organization, errors } = this.props;
        const legalInfo = organization.getLegalInfo();

        const items = legalInfo.map((item, index) => (
            <Form.Item
                key={index}
                errors={errors[item.type]}
                label={i18n(`organization_profile.legal_info.${FIELD_MAP[item.type] || item.type}`)}
            >
                <Input
                    name={item.type}
                    hasClear
                    size="m"
                    autoComplete={false}
                    width="available"
                    val={item.value}
                />
            </Form.Item>
        ));

        items.push(
            <Form.Item
                key="head"
                errors={errors.head}
                label={i18n('organization_profile.legal_info.head')}
            >
                <input
                    type="hidden"
                    name="head_id"
                    value={head ? head.getId() : ''}
                />
                <SuggestPicker
                    id="org-profile-form-head"
                    suggest
                    multiple={false}
                    onChange={this._handlePickerChange}
                    type="user"
                    value={head ? [head] : []}
                    width="available"
                />
            </Form.Item>
        );

        return (
            <div className="form__subsection">
                {items}
            </div>
        );
    },

});

LegalInfo.propTypes = {
    organization: PropTypes.object,
    errors: PropTypes.object,
};

export default LegalInfo;
