import React from 'react';
import { Permissions } from 'constants/Common';
import Scrollable from 'ui/Scrollable';
import StoreMixin from 'lib/StoreMixin';

import AuthStore from 'stores/Auth';
import OrganizationStore from 'stores/Organizations';
import PermissionStore from 'stores/Permissions';

import Identity from './Components/Identity';
import Owner from './Components/Owner';
import Contacts from './Components/Contacts';
import TechnicalDetails from './Components/TechnicalDetails';
import ADConnectorMessage from './Components/ADConnectorMessage';
import Edit from './Controls/Edit';

import './index.css';

const Section = React.createClass({

    mixins: [StoreMixin],

    getStoreState() {
        return { organization: AuthStore.getOrganization() };
    },

    componentDidMount() {
        this.subscribe([
            AuthStore, OrganizationStore, PermissionStore,
        ]);
    },

    render() {
        const { organization } = this.state;
        let controls;

        const editable =
            PermissionStore.contains(Permissions.EDIT_ORGANIZATION) ||
            PermissionStore.contains(Permissions.DELETE_ORGANIZATION);

        if (editable) {
            controls = <Edit organization={organization} />;
        }

        return (
            <div className="org-profile-section card-section section">
                <div className="section-body">
                    <Scrollable>
                        {controls}
                        <Identity organization={organization} />
                        <Owner organization={organization} />
                        <Contacts organization={organization} />
                        <TechnicalDetails organization={organization} />
                        <ADConnectorMessage />
                    </Scrollable>
                </div>
            </div>
        );
    },

});

Section.propTypes = {

};

export default Section;
