import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import Scrollable from 'ui/Scrollable';
import StoreMixin from 'lib/StoreMixin';
import UIStore from 'stores/UI';
import UIActions from 'actions/UI';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import { i18n } from 'lib/i18n';
import UpdateForm from './Forms/Update';

const UpdateSection = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        return {
            suggestListOpen: UIStore.get('suggest_list_open', 'org-profile-form-head'),
        };
    },

    componentDidMount() {
        this.subscribe(UIStore);
    },

    _handleEditDone() {
        UIActions.orgProfileEdited();
    },

    render() {
        let suggestListPlaceholder;

        // добавляем пустышку внизу формы, если поле выбора руководителя активно,
        // чтобы список саджеста в этом поле не обрезался краем страницы
        if (this.state.suggestListOpen) {
            suggestListPlaceholder = <div className="suggest-list-placeholder" />;
        }

        return (
            <div className="update-org-profile-section card-section section">
                <div className="section-body">
                    <Scrollable>

                        <UpdateForm
                            onSubmit={this._handleEditDone}
                            onCancel={this._handleEditDone}
                        />

                        {suggestListPlaceholder}

                        <div className="section__close">
                            <FlatButton
                                onClick={this._handleEditDone}
                                ariaLabel={i18n('common.action.cancel')}
                            >

                                <Icon type="cross" />
                            </FlatButton>
                        </div>

                    </Scrollable>
                </div>
            </div>
        );
    },

});

UpdateSection.propTypes = {

};

export default UpdateSection;
