import React from 'react';
import ApplicationStore from 'stores/Application';

import AdminList from 'components/OrgAdmins';
import User from 'components/User';

const OrgAdmins = React.createClass({

    render() {
        const sections = ApplicationStore.getSectionValues();
        const nestedComponents = [];

        if (sections.slice(0, 2).join('/') !== 'customization/admins') {
            return null;
        }

        if (sections[2]) {
            nestedComponents.push(<User id={sections[2]} key="admin" />);
        }

        return (
            <div className="section-layout-container">
                <AdminList />
                {nestedComponents}
            </div>
        );
    },

});

export default OrgAdmins;
