import React from 'react';
import { i18n } from 'lib/i18n';
import Url from 'lib/Url';
import ConfigStore from 'stores/Config';
import Link from 'ui/Link';
import { ServiceIcon } from 'components/Icon';

import './promo.css';

const NAME = 'org-setup-promo';
const LOGOS = ['yamb', 'wiki', 'tracker', 'mail', 'disk'];

const Promo = props => {
    let description;

    if (props.serviceId) {
        description = i18n(`organization_setup.promo.description.${props.serviceId}`);
    }

    return (
        <div className={NAME}>
            <div className={`${NAME}__logo`}>
                <img
                    src={Url.build(ConfigStore.get('ui.logo'), { text: i18n('common.yandex') })}
                    alt={i18n('common.yandex')}
                />
                <img
                    src={Url.build(ConfigStore.get('ui.logo'), { text: i18n('common.connect') })}
                    alt={i18n('common.connect')}
                />
            </div>
            <div className={`${NAME}__title`}>
                {i18n('organization_setup.promo.title')}
            </div>
            <div className={`${NAME}__services`}>
                {LOGOS.map(id => <Logo id={id} key={id} selected={id === props.serviceId} />)}
            </div>
            <div className={`${NAME}__description`}>
                {description || i18n('organization_setup.promo.description.common')}
            </div>
            <div className={`${NAME}__footer`}>
                <Link to={ConfigStore.getHelpUrl('ui.help.main', { tld: ConfigStore.get('app.tld') })}>
                    {i18n('common_options.help')}
                </Link>
                <span className={`${NAME}__copyright`}>
                    <span>© 2001–{(new Date()).getFullYear()}, </span>
                    <Link to={ConfigStore.get('ui.rootPage')}>
                        {i18n('common.yandex')}
                    </Link>
                </span>
            </div>
        </div>
    );
};

const Logo = props => {
    const className = [
        `${NAME}__service-logo`,
        props.selected ? `${NAME}__service-logo_selected` : null,
    ].filter(Boolean).join(' ');

    return (
        <div
            id={`logo-${props.id}`}
            className={className}
            title={i18n(`related_services.${props.id}`)}
        >
            <ServiceIcon
                serviceSlug={props.id}
                title={i18n(`related_services.${props.id}`)}
            />
        </div>
    );
};

export default Promo;
