import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import { i18n } from 'lib/i18n';
import ConfigStore from 'stores/Config';
import ModalActions from 'actions/Modal';
import SettingsActions from 'actions/Settings';

import FeedbackForm from 'ui/FeedbackForm';

import StoreMixin from 'lib/StoreMixin';
import SettingsStore from 'stores/Settings';
import PinnedNotification from './index';

const SETTING_KEY = 'automigration_survey_status';

function updateSetting(newValue) {
    return SettingsActions.updateSettings({
        [SETTING_KEY]: newValue,
    });
}

const AutomigrationSurvey = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return {
            status: SettingsStore.get(SETTING_KEY),
        };
    },

    componentDidMount() {
        this.subscribe(SettingsStore);
    },

    _shouldRender() {
        return this.state.status === 'required';
    },

    _showSurveyForm() {
        ModalActions.open({
            component: FeedbackForm,
            props: {
                src: ConfigStore.get('ui.automigrationSurvey'),
                className: 'automigration-survey-form pinned-notification__survey-form',
                onSend: () => {
                    updateSetting('sent');
                },
            },
        });

        updateSetting('open');
    },

    _cancelSurvey() {
        updateSetting('canceled');
    },

    render() {
        if (!this._shouldRender()) {
            return null;
        }

        return (
            <PinnedNotification
                content={i18n('intro.automigration_survey.content')}
                confirmButtonText={i18n('intro.automigration_survey.agree')}
                onConfirm={this._showSurveyForm}
                onCancel={this._cancelSurvey}
            />
        );
    },

});

export default AutomigrationSurvey;
