import PropTypes from 'prop-types';
import React from 'react';
import { Button, Link } from 'lego-on-react';
import { block } from 'bem-cn';
import { i18n } from 'lib/i18n';
import Icon from 'ui/Icon';

import './index.css';
const bPinnedNotification = block('pinned-notification');

const PinnedNotification = React.createClass({

    getInitialState() {
        return { closed: false };
    },

    _onConfirm() {
        this.setState({ closed: true });
        this.props.onConfirm();
    },

    _onCancel() {
        this.setState({ closed: true });
        this.props.onCancel();
    },

    render() {
        const { confirmButtonText, content } = this.props;

        if (this.state.closed) {
            return null;
        }

        return (
            <div className={bPinnedNotification()}>
                <div className={bPinnedNotification('content')}>
                    {content}
                </div>
                <Button
                    theme="action"
                    size="s"
                    cls={bPinnedNotification('button', { role: 'cancel' })}
                    onClick={this._onConfirm}
                >
                    {confirmButtonText || i18n('common.action.ok')}
                </Button>
                <Link
                    theme="normal"
                    type="pseudo"
                    cls={bPinnedNotification('cancel')}
                    onClick={this._onCancel}
                >
                    <Icon type="thin-cross" />
                </Link>
            </div>
        );
    },

});

PinnedNotification.propTypes = {
    confirmButtonText: PropTypes.string.isRequired,
    content: PropTypes.string.isRequired,
    onCancel: PropTypes.func.isRequired,
    onConfirm: PropTypes.func.isRequired,
};

export default PinnedNotification;
