import { i18n, formatDate } from 'lib/i18n';
import './list.css';

const List = props => {
    if (!props.items || !props.items.length) {
        return (
            <div className="promocode-list-placeholder">
                {i18n('subscription.promocode.list.placeholder')}
            </div>
        );
    }

    const items = props.items.map((itemProps, index) => <List.Item {...itemProps} key={index} />);

    return (
        <div className="promocode-list">
            <table>
                <tbody>{items}</tbody>
            </table>
        </div>
    );
};

List.Item = props => {
    const status = props.status || 'activated';

    return (
        <tr data-status={status}>
            <th>{i18n('subscription.promocode.title', { name: props.name || props.id })}</th>
            <td>{props.description}</td>
            <td className="notes">
                <div className="status-badge">
                    {i18n(`subscription.promocode.status.${status}`) || status}
                </div>
                <div className="details">
                    {i18n('subscription.promocode.expires', { date: formatDate(props.expires) })}
                </div>
            </td>
        </tr>
    );
};

export default List;
