import React from 'react';
import { block } from 'bem-cn';
import { Icon } from 'lego-on-react';

import Button from 'lego-ui/Button';
import QuestionIcon from 'components/Icon/Question';
import TooltipBox from 'components/TooltipBox';

import { i18n } from 'lib/i18n';
import ConfigStore from 'stores/Config';
import isDomainUser from 'lib/isDomainUser';

import './YaOrgButton.css';

const b = block('registration');

export const YaOrgButton = () => {
    // CONNECT_UI__ALLOW_CREATE_YA_ORG=true
    if (!ConfigStore.get('ui.allowCreateYaOrg') || isDomainUser()) return null;

    return (
        <Button
            text={i18n('registration.add_ya_org')}
            view="action"
            width="available"
            cls={b('ya-org-button')}
            onClick={() => location.assign(ConfigStore.get('ui.cloud.orgCreate'))}
            addonRight={(
                <TooltipBox
                    tip={i18n('registration.ya_org_tooltip')}
                    theme="normal"
                    to="right"
                    size="s"
                    noHideOnTooltip
                    hideDelay={500}
                    cls={b('ya-org-tip')}
                >
                    <Icon
                        cls={b('ya-org-tip-icon')}
                        glyph="yes"
                    >
                        <QuestionIcon />
                    </Icon>
                </TooltipBox>
            )}
        />
    );
};
