import Registration from 'components/Registration';
import Footer from 'components/Footer';

import { i18n } from 'lib/i18n';

import './index.css';

import ConfigStore from 'stores/Config';

export default () => (
    <div className="registration-page">
        <div className="registration-page__content">
            <div className="registration-page__header">
                <a href={ConfigStore.get('ui.rootPage')}>
                    <img
                        className="registration-page__img_title"
                        src={ConfigStore.get('ui.logo', { text: i18n('common.yandex') })}
                        alt={i18n('common.yandex')}
                    />
                </a>

                <a href="/?noredirect=1">
                    <img
                        className="registration-page__img_service"
                        src={ConfigStore.get('ui.logo', { text: i18n('common.connect') })}
                        alt={i18n('common.connect')}
                    />
                </a>
            </div>
            <Registration />
        </div>
        <Footer align="center" />
    </div>
);
