import React from 'react';

import { block } from 'bem-cn';

import { Button, Icon } from 'lego-on-react';
import Unit from 'ui/Unit';

import removeIcon from '../../../static/i/remove.svg';

const bTable = block('table');

export default class extends React.Component {
    constructor(props) {
        super(props);
        this.onClick = this.onClick.bind(this);
    }

    onClick() {
        this.props.onClick(this.props.id);
    }

    render() {
        const { avatar, name, position, role, comment, editable } = this.props;

        return (
            <tr className={bTable('row')}>
                <td className={bTable('cell', { tight: true })}>
                    <Unit
                        avatar={avatar}
                        showDescription
                        description={position}
                        title={name}
                    />
                </td>
                <td className={bTable('cell')}>
                    <div className={bTable('text')}>{role}</div>
                    {comment && <div className={bTable('text', { secondary: true })}>{comment}</div>}
                </td>
                <td className={bTable('cell')}>
                    {editable && (
                        <div className={bTable('controls', { hoverable: true })}>
                            <Button
                                theme="clear"
                                size="s"
                                icon={<Icon url={removeIcon} />}
                                onClick={this.onClick}
                            />
                        </div>
                    )}
                </td>
            </tr>
        );
    }
}
