import React from 'react';

import { block } from 'bem-cn';
import { Button, Icon } from 'lego-on-react';
import ConfigStore from 'stores/Config';

import Url from 'lib/Url';
import { i18n } from 'lib/i18n';

import Unit from 'ui/Unit';

import TooltipBox from 'components/TooltipBox';
import { Info } from 'components/Icon';

import removeIcon from '../../../static/i/remove.svg';

const bTable = block('table');

export default class extends React.Component {
    constructor(props) {
        super(props);

        this.onDeny = this.onDeny.bind(this);
        this.onConfirm = this.onConfirm.bind(this);
    }

    onConfirm() {
        const { onConfirm, userId, external } = this.props;

        onConfirm(userId, external);
    }

    onDeny() {
        const { onDeny, userId } = this.props;

        onDeny(userId);
    }

    render() {
        const {
            avatarId,
            name,
            position,
            external,
            role,
            comment,
            editable,
            getText,
        } = this.props;

        const fullName = name ? `${name.first} ${name.last}` : '';

        const avatar = Url.build(ConfigStore.get('ui.avatar.url'), {
            id: avatarId || '0',
            size: 200,
        });

        let accessory = getText('user_accessory.worker');

        if (external) {
            accessory = [
                getText('user_accessory.external'),
                <TooltipBox
                    key="external-tooltip"
                    tip={getText('user_is_external')}
                    to="bottom"
                    size="s"
                    theme="normal"
                    cls={bTable('cell-tooltip')}
                >
                    <Info className={bTable('cell-icon')} />
                </TooltipBox>,
            ];
        }

        return (
            <tr className={bTable('row')}>
                <td className={bTable('cell', { tight: true })}>
                    <Unit
                        avatar={avatar}
                        showDescription
                        description={position}
                        title={fullName}
                    />
                </td>
                <td className={bTable('cell')}>
                    <div className={bTable('text')}>{accessory}</div>
                </td>
                <td className={bTable('cell')}>
                    <div className={bTable('text')}>{role}</div>
                    {comment && <div className={bTable('text', { secondary: true })}>{comment}</div>}
                </td>
                <td className={bTable('cell')}>
                    {editable && (
                        <div className={bTable('controls', { hoverable: true })}>
                            <Button
                                text={i18n('common.action.confirm')}
                                size="s"
                                theme="action"
                                onClick={this.onConfirm}
                            />
                            <Button
                                theme="clear"
                                size="s"
                                icon={<Icon url={removeIcon} />}
                                onClick={this.onDeny}
                            />
                        </div>
                    )}
                </td>
            </tr>
        );
    }
}
