import React from 'react';

import PureRenderMixin from 'react-addons-pure-render-mixin';
import { block } from 'bem-cn';
import StoreMixin from 'lib/StoreMixin';

import UserStore from 'stores/Users';
import ResourcesStore from 'stores/Resources';
import PermissionStore from 'stores/Permissions';

import Tabs from 'lego-ui/Tabs';
import { i18n } from 'lib/i18n';

import Main from 'components/Main';
import ResourceHeader from 'components/ResourceHeader';
import RelationList from 'components/RelationList';
import RequestList from 'components/RequestList';

import './index.css';

const bResource = block('resource-page');

export default React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        const { serviceSlug, resourceId } = this.props.params;

        const nextState = { requestsCount: ResourcesStore.getRequestCount(serviceSlug, resourceId) };

        if (!this.state || !nextState.requestsCount) {
            nextState.selectedTabId = 'relations';
        }

        return nextState;
    },

    componentDidMount() {
        this.subscribe([ResourcesStore, UserStore, PermissionStore]);
    },

    _getText(key, params) {
        const { serviceSlug } = this.props.params;

        return i18n(`resource_page.${serviceSlug}.${key}`, params) ||
            i18n(`resource_page.default.${key}`, params);
    },

    _setSelectedTabId(selectedTabId) {
        this.setState({ selectedTabId });
    },

    render() {
        const { serviceSlug, resourceId } = this.props.params;
        const { requestsCount, selectedTabId } = this.state;
        let { metadata: { name, description } } = ResourcesStore.getResource(serviceSlug, resourceId);

        return (
            <Main cls={bResource()}>
                <ResourceHeader
                    serviceSlug={serviceSlug}
                    resourceId={resourceId}
                    name={name}
                    description={description}
                />
                {PermissionStore.allowsServiceDataView(serviceSlug) &&
                <Tabs
                    selectedTabId={selectedTabId}
                    onChange={this._setSelectedTabId}
                >
                    <Tabs.Item
                        id="relations"
                        title={this._getText('relations_tab')}
                    >
                        <RelationList
                            serviceSlug={serviceSlug}
                            resourceId={resourceId}
                        />
                    </Tabs.Item>
                    {requestsCount &&
                        <Tabs.Item
                            id="requests"
                            title={[
                                this._getText('requests_tab'),
                                <span
                                    className={bResource('requests-counter')}
                                    key={`${serviceSlug}-${resourceId}-requests`}
                                >
                                    {requestsCount}
                                </span>,
                            ]}
                        >
                            <RequestList
                                serviceSlug={serviceSlug}
                                resourceId={resourceId}
                            />
                        </Tabs.Item>}
                </Tabs>}
            </Main>
        );
    },

});
