import { Statuses } from 'constants/Restore';
import Url from 'lib/Url';
import RestoreStore from 'stores/Restore';
import { i18n, formatDateTime } from 'lib/i18n';

import Link from 'ui/Link';
import ButtonLink from 'lego-ui/ButtonLink';

const ListItem = props => {
    const details = i18n('restore.list.processing_period', {
        date: formatDateTime(props.expires_at),
    });

    return (
        <li className="active-check" key={props.restore_id} data-state={props.state}>
            <Link to={props.state === Statuses.IN_PROGRESS ? Url.getPath(`/restore/${props.restore_id}`) : null}>
                <span className="active-check__domain">
                    {props.domain}
                </span>
                <br />
                <span className="active-check__state">
                    {i18n(`restore.list.status.${props.state}`)}
                </span>
                <br />
                <span
                    className="active-check__details"
                    dangerouslySetInnerHTML={{ __html: details }}
                />
            </Link>
        </li>
    );
};

export default () => (
    <div className="active-checks">
        <h1 className="active-checks__title">
            {i18n('restore.list.title')}
        </h1>
        <ul className="active-checks__list">
            {RestoreStore.getActiveChecks().map(ListItem)}
            <li className="new-check">
                <ButtonLink
                    to={Url.getPath('/restore/new')}
                    text={i18n('restore.new_request')}
                    width="available"
                    view="action"
                />
            </li>
        </ul>
    </div>
);
