import _ from 'lodash';
import { i18n } from 'lib/i18n';
import getVerificationOptions from 'components/Domain/getConfirmationOptions';
import ConfigStore from 'stores/Config';

export default props => {
    if (!props.methods || !props.methods.length) {
        return null;
    }

    const commonData = {
        domain: props.domain,
        tld: ConfigStore.get('app.tld'),
        confirmEmailUrl: ConfigStore.get('passport.session.confirmEmail'),
        buttonText: i18n('domain.action.start_ownership_check'),
        help: ConfigStore.getHelpUrl('ui.help.domain_confirmation'),
    };

    let content;

    props.methods.forEach(item => {
        if (item.method !== props.selectedMethod) {
            return;
        }

        const descriptionData = _.extend({}, item, commonData, {
            method: `webmaster.${item.method}`,
        });

        const descriptionList = getVerificationOptions(descriptionData)
            .map((itemContent, index) => (
                <li
                    key={`${item.method}_${index}`}
                    dangerouslySetInnerHTML={{ __html: itemContent }}
                />
            ));

        content = (
            <div
                className="domain-ownership-method"
                data-id={item.method}
                key={item.method}
            >
                <ol>{descriptionList}</ol>
            </div>
        );
    });

    if (!content) {
        return null;
    }

    return (
        <div className="domain-ownership__instructions">
            {content}
        </div>
    );
};
