import moment from 'moment';
import { i18n } from 'lib/i18n';
import AuthStore from 'stores/Auth';

function formatDate(date) {
    return moment(date).locale(AuthStore.getLocale()).calendar();
}

export default props => {
    if (!props.date) {
        return null;
    }

    const status = i18n(`domain.confirmation_methods.webmaster.error.${props.fail_type}`) ||
        i18n('domain.confirmation_methods.webmaster.error.unknown');

    let description;

    if (status) {
        description = i18n('restore.domain_ownership.last_check_status', {
            method: i18n(`domain.confirmation_methods.webmaster.${props.method}.short_title`),
            date: formatDate(props.date),
            status,
        });
    } else {
        description = i18n('restore.domain_ownership.last_check', {
            method: i18n(`domain.confirmation_methods.webmaster.${props.method}.short_title`),
            date: formatDate(props.date),
        });
    }

    return (
        <div
            className="domain-ownership__last-check"
            dangerouslySetInnerHTML={{ __html: description }}
        />
    );
};
