import { i18n } from 'lib/i18n';
import RadioGroup from 'lego-ui/RadioGroup';

export default props => {
    if (!props.methods) {
        return null;
    }

    const optionList = props.methods.map(item => ({
        val: item.method,
        content: i18n(`domain.confirmation_methods.webmaster.${item.method}.short_title`),
    }));

    return (
        <div className="domain-ownership__toggle">
            <RadioGroup
                options={optionList}
                name="method"
                val={props.val}
                onChange={props.onChange}
            />
        </div>
    );
};
