function toList(s) {
    return s ? s.trim().split(/\s*,\s*/) : [];
}

function toBinary(s) {
    return s === 'true' || s === 'on';
}

function filterInput(data) {
    const controlAnswers = {};

    ['admins', 'users', 'maillists'].forEach(key => {
        controlAnswers[key] = toList(data[key]);
    });

    ['forgot_admins', 'no_users', 'no_maillists'].forEach(key => {
        controlAnswers[key] = toBinary(data[key]);
    });

    return {
        domain: data.domain ? data.domain.trim() : '',
        control_answers: controlAnswers,
    };
}

export default filterInput;
