import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import _ from 'lodash';
import { i18n } from 'lib/i18n';
import { Statuses } from 'constants/Restore';
import timer from 'lib/timer';
import notify from 'services/notify';
import Metrika from 'lib/metrika';
import Url from 'lib/Url';
import { RouteTiming } from 'lib/rum';

import RestoreStore from 'stores/Restore';
import RestoreActions from 'actions/Restore';

import Header from 'components/Header';
import Notifications from 'components/Notifications';
import filterInput from './filterInput';

import ActiveChecks from './ActiveChecks';
import ControlQuestions from './ControlQuestions';
import DomainOwnership from './DomainOwnership';

import './index.css';

function track(...args) {
    Metrika.send.apply(Metrika, ['Восстановление'].concat(args));
}

const Restore = React.createClass({

    mixins: [PureRenderMixin],

    getInitialState() {
        return {};
    },

    componentDidMount() {
        document.body.className = 'loaded connect-app';
        document.body.dataset.section = 'connect-restore';

        track('Начало');

        timer.stop('first_run');

        RouteTiming.end();
    },

    _onSubmit(data) {
        data = filterInput(data);

        if (!data.domain) {
            return notify(i18n('restore.error.no_domain'), 'error');
        }

        if (data.domain.indexOf('.') < 1) {
            return notify(i18n('restore.error.invalid_domain'), 'error');
        }

        return RestoreActions.start(data)
            .then(response => {
                if (response.code) {
                    return notify(i18n(`restore.error.${response.code}`), 'error');
                }

                const restoreId = _.get(response, 'current_check.restore_id');

                if (restoreId) {
                    Url.open(Url.getPath(`/restore/${restoreId}`));
                }
            });
    },

    render() {
        const currentCheck = RestoreStore.getCurrentCheck();
        let body;

        if (currentCheck.state || currentCheck.code) {
            body = (
                <DomainOwnership
                    {...currentCheck}
                    {...RestoreStore.getOwnershipStatus()}
                />
            );
        } else if (RestoreStore.getActiveChecks().length) {
            body = <ActiveChecks />;
        } else {
            body = (
                <ControlQuestions
                    onSubmit={this._onSubmit}
                />
            );
        }

        const containerClassName = [
            'layout-container',
            currentCheck.state === Statuses.INVALID_ANSWERS && 'shaded',
        ].filter(Boolean).join(' ');

        return (
            <div className={containerClassName}>
                <Header searchEnabled={false} orgSwitchEnabled={false} />
                <Notifications />
                <div className="body">
                    {body}
                </div>
            </div>
        );
    },

});

export default Restore;
