import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import ApplicationStore from 'stores/Application';

import Dns from 'components/Dns';

const CardLayout = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return { key: this.hashCode() };
    },

    componentDidMount() {
        this.subscribe(ApplicationStore);
    },

    render() {
        let section;

        switch (ApplicationStore.getSectionName()) {
            case 'dns':
                section = <Dns />;
                break;
        }

        if (!section) {
            return null;
        }

        return (
            <div className="dns-layout section-layout">
                {section}
            </div>
        );
    },

});

export default CardLayout;
