import './empty-department.css';

import PropTypes from 'prop-types';
import React from 'react';
import { block } from 'bem-cn';
import { i18n } from 'lib/i18n';

const bOutstaffRoot = block('department-empty');

const EmptyDepartment = ({ type }) => (
    <div className={bOutstaffRoot}>
        <div className={bOutstaffRoot('content')}>
            <div className={bOutstaffRoot('icon')} />
            <h1 className={bOutstaffRoot('title')}>
                {i18n(`department.empty_title.${type}`)}
            </h1>
            <h2 className={bOutstaffRoot('description')}>
                {i18n(`department.empty_description.${type}`)}
            </h2>
        </div>
    </div>
);

EmptyDepartment.propTypes = {
    type: PropTypes.string.isRequired,
};

export default EmptyDepartment;
