import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';

import ApplicationStore from 'stores/Application';
import GroupStore from 'stores/Groups';

import GroupList from 'components/GroupList';
import Group from 'components/Group';
import User from 'components/User';
import Department from 'components/Department';

const COMPONENT_MAP = {
    group: Group,
    user: User,
    department: Department,
};

const GroupLayout = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return { key: this.hashCode() };
    },

    componentDidMount() {
        this.subscribe([
            ApplicationStore,
            GroupStore,
        ]);
    },

    render() {
        if (ApplicationStore.getPrimaryType() !== 'groups') {
            return null;
        }

        const sections = ApplicationStore.getObjectChain()
            .map((item, index) => {
                const Component = COMPONENT_MAP[item.type];
                const props = { id: item.id, flat: index > 0 };

                if (Component) {
                    return <Component {...props} key={index} />;
                }

                return null;
            });

        sections.unshift(<GroupList key="group-list" />);

        return (
            <div className="group-layout section-layout">
                {sections}
            </div>
        );
    },

});

export default GroupLayout;
