import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import ApplicationStore from 'stores/Application';

import Dns from 'components/Dns';
import OrgAdmins from 'components/OrgSettings/Sections/OrgAdmins';
import GeneralSettingsSection from 'components/GeneralSettings';

import './org-settings.css';

const SECTION_MAP = {
    dns: Dns,
    admins: OrgAdmins,
    general: GeneralSettingsSection,
};

const OrgSettingsLayout = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return {
            key: this.hashCode(),
            subsection: ApplicationStore.getSubsectionName(),
            sections: ApplicationStore.getSections(),
        };
    },

    componentDidMount() {
        this.subscribe(ApplicationStore);
    },

    render() {
        const { subsection } = this.state;

        if (ApplicationStore.getSectionName() !== 'customization' || !SECTION_MAP[subsection]) {
            return null;
        }

        return (
            <div className="organization-settings-layout section-layout">
                {React.createElement(SECTION_MAP[subsection])}
            </div>
        );
    },

});

export default OrgSettingsLayout;
