import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import ApplicationStore from 'stores/Application';

import Subscription from 'components/Subscription';
import SubscriptionService from 'components/SubscriptionService';

const SubscriptionLayout = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return {
            key: this.hashCode(),
        };
    },

    componentDidMount() {
        this.subscribe(ApplicationStore);
    },

    _getSubsection() {
        const sections = ApplicationStore.getSections().map(item => item.value);

        switch (sections[1]) {
            case 'manage':
                return <SubscriptionService serviceSlug="tracker" />;
            case 'agreement':
                return <Subscription />;
        }
    },

    render() {
        if (ApplicationStore.getSectionName() !== 'subscription') {
            return null;
        }

        return (
            <div className="subscription-layout section-layout">
                {this._getSubsection()}
            </div>
        );
    },

});

export default SubscriptionLayout;
