import React from 'react';
import ReactDOM from 'react-dom';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import Scrollable from 'ui/Scrollable';
import StoreMixin from 'lib/StoreMixin';
import ApplicationStore from 'stores/Application';
import { RouteTiming } from 'lib/rum';

import Breadcrumbs from 'components/Breadcrumbs';
import DepartmentLayout from './DepartmentLayout';
import GroupLayout from './GroupLayout';
import CardLayout from './CardLayout';
import DnsLayout from './DnsLayout';
import OrgSettingsLayout from './OrgSettingsLayout';
import SubscriptionLayout from './SubscriptionLayout';

import './index.css';
// import './animation.css';

import './section.css';
import './subsection.css';
import './controls.css';

import './column-section.css';
import './card-section.css';

// import './card-section-animation.css';
import './editable-card-section.css';

const SectionLayout = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return { key: this.hashCode() };
    },

    componentDidUpdate() {
        RouteTiming.end();

        this._scrollToLastSection();
    },

    componentDidMount() {
        RouteTiming.end();

        this.subscribe(ApplicationStore);
        this._scrollToLastSection();
    },

    _scrollToLastSection() {
        setTimeout(() => {
            if (this.refs.scrollPane) {
                this.refs.scrollPane.scrollRight();
                try {
                    // фикс вертикального смещения оргструктуры в Сафари (DIR-4357)
                    const scrollPaneContent = ReactDOM.findDOMNode(this.refs.scrollPane).childNodes[0];

                    scrollPaneContent.style.transform = `translateY(-${scrollPaneContent.offsetTop}px)`;
                } catch (e) {
                    // empty
                }
            }
        }, 0);
    },

    render() {
        return (
            <div className="sections">
                <div className="sections__header">
                    <Breadcrumbs />
                </div>
                <div className="sections__body">
                    <Scrollable
                        className="sections__scrollpane"
                        contentClassName="sections__scrollpane-container"
                        ref="scrollPane"
                        vertical={false}
                    >

                        <DepartmentLayout />
                        <GroupLayout />
                        <CardLayout />
                        <DnsLayout />
                        <OrgSettingsLayout />
                        <SubscriptionLayout />

                    </Scrollable>
                </div>
            </div>
        );
    },

});

export default SectionLayout;
