import PropTypes from 'prop-types';
import React from 'react';
import { block } from 'bem-cn';

import Tip from 'ui/Tip';

import './badge.css';

const bBadge = block('badge');

const Badge = ({ color, size, text, tipText, cls }) => {
    const className = bBadge({ color, size }).mix(cls);

    if (!text) {
        return null;
    }

    return (
        <div className={className}>
            <div className={bBadge('text')}>{text}</div>
            {tipText &&
            <Tip theme="light">
                <div className={bBadge('tip')}>{tipText}</div>
            </Tip>}
        </div>
    );
};

export default Badge;

Badge.propTypes = {
    color: PropTypes.string,
    text: PropTypes.node,
    tipText: PropTypes.node,
};

Badge.defaultProps = {
    size: 's',
    color: 'grey',
};
