import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import { block } from 'bem-cn';
import { TRIAL_STATUS } from 'constants/Services';

import StoreMixin from 'lib/StoreMixin';

import AuthStore from 'stores/Auth';
import OrganizationStore from 'stores/Organizations';

import TrialBadge from './components/TrialBadge';
import PaymentBadge from './components/PaymentBadge';

const bServiceBadge = block('service-badge');

const ServiceBadge = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        const { serviceSlug } = this.props;

        return {
            trialStatus: AuthStore.getServiceTrialStatus(serviceSlug),
        };
    },

    componentDidMount() {
        this.subscribe([AuthStore, OrganizationStore]);
    },

    render() {
        const { serviceSlug, hidePricing, cls, size } = this.props;
        const { trialStatus } = this.state;
        const isTrial = trialStatus === TRIAL_STATUS.IN_PROGRESS;

        return isTrial ?
            !hidePricing &&
            <TrialBadge
                cls={bServiceBadge({}).mix(cls)}
                serviceSlug={serviceSlug}
                size={size}
            /> :
            <PaymentBadge
                cls={bServiceBadge({}).mix(cls)}
                serviceSlug={serviceSlug}
                size={size}
                hidePricing={hidePricing}
            />;
    },

});

export default ServiceBadge;
