import React from 'react';
import { block } from 'bem-cn';
import PropTypes from 'prop-types';

import { i18n } from 'lib/i18n';
import NavLink from 'components/NavLink';
import { ServiceIcon } from 'components/Icon';

import './index.css';

const bServiceResource = block('service-resource');

const ServiceResource = ({ serviceSlug, name, id, description, url, target, actionText, children }) => (
    <div className={bServiceResource()}>
        <div className={bServiceResource('card')}>
            <NavLink
                url={url}
                target={target}
                theme="normal"
                cls={bServiceResource('link')}
                metrika={['Сервис с ресурсами', serviceSlug, 'Клик по ресурсу в списке']}
            >
                <div className={bServiceResource('header')}>
                    <ServiceIcon
                        cls={bServiceResource('icon')}
                        serviceSlug={serviceSlug}
                    />
                    {id && <div className={bServiceResource('id')}>{id}</div>}
                </div>
                {name && <div className={bServiceResource('name')}>{name}</div>}
                {children}
                {description && <div className={bServiceResource('description')}>{description}</div>}
                <div className={bServiceResource('link-text')}>
                    {actionText || i18n(`service_page.${serviceSlug}.manage_resource`) ||
                        i18n('service_page.default.manage_resource')}
                </div>
            </NavLink>
        </div>
    </div>
);

ServiceResource.propTypes = {
    serviceSlug: PropTypes.string.isRequired,
    url: PropTypes.string.isRequired,
    actionText: PropTypes.string,
    id: PropTypes.string,
    name: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
    description: PropTypes.string,
};

export default ServiceResource;
