import React from 'react';

import PureRenderMixin from 'react-addons-pure-render-mixin';
import Loader from 'ui-components/lib/Loader';
import StoreMixin from 'lib/StoreMixin';
import UIStore from 'stores/UI';

const SettingsLoader = React.createClass({
    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return {
            isLoading: UIStore.get('isSettingsLoading'),
        };
    },

    componentDidMount() {
        this.subscribe(UIStore);
    },

    render() {
        const { isLoading } = this.state;

        if (!isLoading) {
            return null;
        }

        return <Loader visible />;
    },
});

export default SettingsLoader;
