import React from 'react';
import { block } from 'bem-cn';

import { Link } from 'lego-on-react';

import './menuItem.css';

const bSidebar2 = block('sidebar2');

export default function({ onClick, active, url, icon, title }) {
    return (
        <Link
            cls={bSidebar2('menu-item', { active })}
            url={url}
            onClick={onClick}
            theme="sidebar"
        >
            {icon && <div className={bSidebar2('menu-icon')}>{icon}</div>}
            {title && <div className={bSidebar2('menu-title')}>{title}</div>}
        </Link>
    );
}
