import { RadioButton } from 'lego-on-react';
import block from 'bem-cn';
import { i18n } from 'lib/i18n';

const b = block('entity-type');

function EntityType(props) {
    return (
        <div className={b()}>
            <RadioButton
                theme="normal"
                view="default"
                tone="default"
                size="m"
                value={props.val}
                onChange={props.onChange}
            >
                <RadioButton.Radio
                    value="natural"
                    cls={b('radio', { type: 'natural' })}
                >
                    {i18n('subscription.entity_type.natural_person')}
                </RadioButton.Radio>
                <RadioButton.Radio
                    value="legal"
                    cls={b('radio', { type: 'legal' })}
                >
                    {i18n('subscription.entity_type.legal_person')}
                </RadioButton.Radio>
            </RadioButton>
        </div>
    );
}

export default EntityType;
