import React from 'react';
import { Button } from 'lego-on-react';
import { i18n, formatCurrency, formatDate } from 'lib/i18n';
import ConfigStore from 'stores/Config';
import SubscriptionStore from 'stores/Subscription';

import ActivateForm from 'components/PromoCode/Activate';

import Form from 'ui/Form';

function getError(props, key) {
    if (props.errors && props.errors.get) {
        return props.errors.get(key);
    }
}

const Payment = props => {
    const component = {};
    const nextActDate = SubscriptionStore.get('current.next_act_date');

    const totalAmount = {
        withDiscount: SubscriptionStore.get('pricing.services.connect.total_with_discount'),
        original: SubscriptionStore.get('pricing.services.connect.total'),
    };
    const isDiscountApplied = typeof totalAmount.withDiscount === 'number';

    const content = {
        infoBox: i18n('subscription.payment.paid_plan_start', {
            date: formatDate(nextActDate),
        }),
        totalPrice: i18n('subscription.payment.total_price', {
            plan: i18n('subscription.plan.paid.name'),
            price: formatCurrency(
                isDiscountApplied ? totalAmount.withDiscount : totalAmount.original,
                SubscriptionStore.get('pricing.currency')
            ),
        }),
        agreement: i18n('subscription.payment.auto_agreement', {
            offer_url: ConfigStore.get('ui.help.offer'),
        }),
        footnote: i18n('subscription.discount_note.single_amount'),
    };

    if (nextActDate) {
        content.description = i18n('subscription.payment.post_payment.next_date', {
            date: formatDate(nextActDate),
        });
    } else {
        content.description = i18n('subscription.payment.post_payment.no_date');
    }

    if (props.enabled) {
        component.title = (
            <div className="payment__title">
                {i18n('subscription.payment.title')}
            </div>
        );
        component.price = (
            <div
                className="payment__price"
                dangerouslySetInnerHTML={{ __html: content.totalPrice }}
            />
        );
    }

    const className = [
        'payment',
        isDiscountApplied && 'payment_discount-applied',
    ].filter(Boolean).join(' ');

    return (
        <div className={className}>
            {component.title}
            <div className="payment__promocode">
                <ActivateForm statusDetails />
            </div>
            <div className="payment__body">
                <div
                    className="payment__terms"
                    dangerouslySetInnerHTML={{ __html: content.agreement }}
                />
                <div className="payment__error">
                    <Form.Error value={getError(props, '_common')} />
                </div>
                <div className="payment__controls">
                    <Button
                        progress={props.busy}
                        text={i18n('common.action.save')}
                        theme="action"
                        size="m"
                        type="submit"
                    />
                    {component.price}
                </div>
            </div>
        </div>
    );
};

export default Payment;
