import { RadioBox } from 'lego-on-react';
import block from 'bem-cn';
import { i18n } from 'lib/i18n';
import './person-id.css';

const b = block('person-id');

function getName({ first_name: first, middle_name: middle, last_name: last, long_name: long }) {
    return [
        first,
        middle,
        last,
        long,
    ].filter(Boolean).join(' ');
}

const PersonId = ({ persons, value, onChange, cls }) => {
    const content = persons.map(data => {
        const { person_id: personId, type } = data;

        return (
            <RadioBox.Radio
                cls={b('radio', { type: personId })}
                key={personId}
                value={personId}
                checked={String(personId) === value}
            >
                <span className={b('name')}>
                    {getName(data)}
                </span>
                <span className={b('type')}>
                    {i18n(`subscription.entity_type.${type}_person`)}
                </span>
            </RadioBox.Radio>
        );
    });

    return (
        <div className={b({}).mix(cls)}>
            <h2 className={b('title')}>
                {i18n('subscription.person_id.title')}
            </h2>
            <RadioBox
                cls={b('radiobox')}
                view="classic"
                theme="normal"
                size="m"
                onChange={onChange}
            >
                {content}
            </RadioBox>
        </div>
    );
};

export default PersonId;
