import PropTypes from 'prop-types';
import React from 'react';
import { Button } from 'lego-on-react';
import { i18n, pluralize, formatCurrency } from 'lib/i18n';
import Link from 'ui/Link';

import ConfigStore from 'stores/Config';

const ChangePrice = props => {
    const { serviceName, currentPricing, newPricing, currency, onConfirm } = props;
    const newPricePerUser = newPricing.per_user_with_discount || newPricing.per_user;
    const newSubscriptionCount = newPricing.users_count - currentPricing.users_count;

    return (
        <div className="license-requests__change-price">
            <p className="license-requests__change-price-text">
                {i18n('license_requests.change_price.descr1', {
                    n_subscriptions: pluralize(newSubscriptionCount, i18n('balance.services.subscriptions')),
                })}
            </p>
            <p
                className="license-requests__change-price-text"
                dangerouslySetInnerHTML={{
                    __html: i18n('license_requests.change_price.descr2', {
                        users_count: newPricing.users_count,
                        price: formatCurrency(newPricePerUser, currency),
                    }),
                }}
            />
            <Link
                target="_blank"
                className="licenses__link licenses__link_external license-requests__change-price-link"
                to={ConfigStore.get(`ui.about.${serviceName}`)}
            >

                {i18n('license_requests.change_price.link_about')}
            </Link>
            <Button
                text={i18n('license_requests.change_price.confirm_button', {
                    n_subscriptions: pluralize(newSubscriptionCount, i18n('balance.services.subscriptions')),
                })}
                theme="action"
                size="m"
                onClick={onConfirm}
            />
        </div>
    );
};

ChangePrice.propTypes = {
    currentPricing: PropTypes.object,
    newPricing: PropTypes.object,
    currency: PropTypes.string,
    onConfirm: PropTypes.func,
};

export default ChangePrice;
