import React from 'react';
import classSet from 'classnames';
import Header from 'components/Header';
import { i18n } from 'lib/i18n';
import timer from 'lib/timer';
import './index.css';

const Unknown = React.createClass({

    componentDidMount() {
        timer.stop('first_run');
        document.body.className = 'loaded';
    },

    render() {
        const randomIndex = Math.floor(Math.random() + .5);
        const className = classSet({
            'unknown-page': true,
            [`unknown-page__type-${randomIndex}`]: true,
        });

        return (
            <div className={className}>
                <Header searchEnabled={false} />
                <div className="unknown-page__content">
                    <h1>{i18n('unknown_page.title')}</h1>
                    <p>{i18n('unknown_page.description')}</p>
                </div>
            </div>
        );
    },
});

export default Unknown;
