import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import UserStore from 'stores/Users';
import Url from 'lib/Url';
import Link from 'ui/Link';

import './index.css';

const Department = React.createClass({

    render() {
        const user = UserStore.get(this.props.id);
        const department = user ? user.getDepartment() : null;

        if (!department) {
            return null;
        }

        return (
            <div className="user-department separated-subsection">
                <div className="list-item">
                    <div className="list-item__key" title={i18n('user.department')}>
                        {i18n('user.department')}:
                    </div>
                    <div className="list-item__value">
                        <Link
                            to={Url.getDepartmentPath(department.id)}
                            className="link"
                            metrika={['Карточка пользователя', 'Клик в департамент']}
                            title={department.getName()}
                        >
                            {department.getName()}
                        </Link>
                    </div>
                </div>
            </div>
        );
    },

});

Department.propTypes = {
    id: PropTypes.string,
};

export default Department;
