import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';

import UserStore from 'stores/Users';
import PermissionStore from 'stores/Permissions';
import UIStore from 'stores/UI';

import Section from './Section';

import './index.css';

const EditableSection = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return { key: this.hashCode() };
    },

    componentDidMount() {
        this.subscribe([
            UserStore,
            PermissionStore,
            UIStore,
        ]);
    },

    render() {
        const { id } = this.props;

        if (!UserStore.get(id)) {
            return null;
        }

        let section = UIStore.getUserCard(id);

        if (!section) {
            section = <Section id={id} />;
        }

        return section;
    },

});

EditableSection.propTypes = {
    id: PropTypes.string,
};

export default EditableSection;
